//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Messaging;

namespace FrameworkLibraries
{
	public class MessageQueueReceive 
	{

		static void Main(string [] args)
		{
			// Utworzenie nowego egzemplarza klasy.
			MessageQueueReceive q = new MessageQueueReceive();
			// Odbir wiadomoci z kolejki.
			q.ReceiveMessage();
			return;
		}

		//**************************************************
		// Odbiera wiadomo zawierajc zamwienie.
		//**************************************************
		public void ReceiveMessage()
		{
			// Poczenie z kolejk na komputerze lokalnym.
			MessageQueue myQueue = new MessageQueue(".\\myQueue");

			// Ustawienie formatera w celu wskazania, e wiadomo zawiera polecenie.
			myQueue.Formatter = new XmlMessageFormatter(new string[]{"System.String"});
         
			try
			{
				// Odbir i formatowanie wiadomoci. 
				// Odczekanie 5 sekund na nadejcie wiadomoci.
				Message myMessage =   myQueue.Receive(new TimeSpan(0,0,5)); 
				string messageText = (string)myMessage.Body;
				// Wywietlenie informacji o wiadomoci.
				Console.WriteLine("Wiadomo odebrana: " + messageText);
			}
			catch (MessageQueueException e)
			{
				// Postpowanie w przypadku braku wiadomoci w kolejce.
				if (e.MessageQueueErrorCode == MessageQueueErrorCode.IOTimeout)
				{
					Console.WriteLine("W kolejce nie ma adnych wiadomoci.");
				}         

				// Obsuga innych rde wyjtku MessageQueueException.
			}
         
			// Obsuga niewaciwego formatu szeregowania.
			catch (InvalidOperationException e)
			{
				Console.WriteLine(e.Message);
			}
         
			// Przechwycenie innych wyjtkw w razie potrzeby.

			return;
		}
	}
}